<?php
include('dbconnect.php');
include('function.php'); // Include the file where your function is defined

if (isset($_POST['lead_id'])) {
    $leadId = $_POST['lead_id'];

    // Prepare the SQL statement to prevent SQL injection
    $stmt = $conn->prepare("SELECT tbl_lead_user_prj_id FROM tbl_lead_user_projects WHERE tbl_lead_user_id = ?");
    $stmt->bind_param("i", $leadId);
    $stmt->execute();
    $result = $stmt->get_result();

    $projects = array();
    while ($row = $result->fetch_assoc()) {
        $projectId = $row['tbl_lead_user_prj_id'];
        $projectName = getproject_name($projectId); // Call your function

        $projects[] = array(
            'tbl_lead_user_prj_id' => $projectId,
            'tbl_lead_user_projects_name' => $projectName
        );
    }

    echo json_encode($projects);
}
?>
