<?php
include('dbconnect.php');
include('function.php');

// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Get the action from POST request
$action = $_POST['action'] ?? '';

switch($action) {
    case 'apply':
        // Get selected projects from POST
        $selectedProjects = $_POST['projects'] ?? [];
        
        // Store in session
        $_SESSION['selected_projects'] = $selectedProjects;
        
        // Return success response
        echo json_encode(['status' => 'success', 'message' => 'Projects filter applied']);
        break;
        
    case 'statusporjectapply':
        // Get selected projects from POST
        $selectedStatusProjects = $_POST['statusprojects'] ?? [];
        
        // // Define mapping from ID to name
        // $statusProjectNames = [
        //     "1" => "Not Connected",
        //     "2" => "In Progress",
        //     "3" => "SV Scheduled",
        //     "4" => "SV Completed",
        //     "5" => "Booking Completed",
        //     "6" => "Dead Lead",
        //     "7" => "EOI Completed"
        // ];
    
        // // Convert selected IDs to names
        // $selectedStatusProjectNames = array_map(function($id) use ($statusProjectNames) {
        //     return $statusProjectNames[$id] ?? "Unknown Status ($id)";
        // }, $selectedStatusProjects);
        
        // Store in session
        $_SESSION['selected_status_projects'] = $selectedStatusProjects;
        
        // Return success response
        echo json_encode(['status' => 'success', 'message' => 'Status Projects filter applied']);
        break;
        
    case 'applystatus':
        // Get selected projects from POST
        $selectedStatusProjects = $_POST['statusprojects'] ?? [];
        
        // Store in session
        $_SESSION['selected_status_projects'] = $selectedStatusProjects;
        
        // Return success response
        echo json_encode(['status' => 'success', 'message' => 'Status Projects filter applied']);
        break;
        
    case 'assigneduserapply':
        // Get selected projects from POST
        $selectedProjects = $_POST['assigneduser'] ?? [];
        
        // Store in session
        $_SESSION['assigned_user'] = $selectedProjects;
        
        // Return success response
        echo json_encode(['status' => 'success', 'message' => 'Projects filter applied']);
        break;
        
    case 'createddateapply':
        // Get selected projects from POST
        $dateoption = $_POST['dateOption']=='' ? '' : $_POST['dateOption'];
        $datestart = $_POST['startDate']=='' ? '' : $_POST['startDate'];
        $dateend = $_POST['endDate']=='' ? '' : $_POST['endDate'];
        
        // Store in session
        $_SESSION['date_option'] = $dateoption;
        $_SESSION['date_start'] = $datestart;
        $_SESSION['date_end'] = $dateend;
        
        // Return success response
        echo json_encode(['status' => 'success', 'message' => 'Date filter applied']);
        break;
        
    case 'clear':
        // Clear the session variable
        unset($_SESSION['selected_projects']);
        
        // Return success response
        echo json_encode(['status' => 'success', 'message' => 'Projects filter cleared']);
        break;
        
    case 'clearassigneduser':
        // Clear the session variable
        unset($_SESSION['assigned_user']);
        
        // Return success response
        echo json_encode(['status' => 'success', 'message' => 'Projects filter cleared']);
        break;
    
    case 'clearcreateddate':
        // Clear the session variable
        unset($_SESSION['date_option']);
        unset($_SESSION['date_start']);
        unset($_SESSION['date_end']);
        
        // Return success response
        echo json_encode(['status' => 'success', 'message' => 'Projects filter cleared']);
        break;
        
    default:
        // Return error for invalid action
        echo json_encode(['status' => 'error', 'message' => 'Invalid action']);
        break;
}
?> 