<?php
// Include the database configuration file
include('dbconnect.php'); 

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Get email and password from the form
    $email = $_POST['example-email'];
    $password = $_POST['example-password'];

    // Sanitize email input
    $email = filter_var($email, FILTER_SANITIZE_EMAIL);

    // Prepare and execute the query to fetch the user from the database
    $query = "SELECT * FROM tbl_invite_user WHERE email = ?";
    if ($stmt = $conn->prepare($query)) {
        $stmt->bind_param("s", $email);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
           
            // User exists, now verify the password
            $user = $result->fetch_assoc();
            echo $password;
            echo $user['password'];
            if ($password == $user['password']) {
              
                // Password is correct, set session variables
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['user_email'] = $user['email'];
                $_SESSION['role'] = $user['role'];
                $_SESSION['name'] = $user['name'];
                // Redirect to the dashboard
                //header("Location: dashboard-manager.php");
                print("<script language='javascript'>window.location.href='dashboard-manager.php';</script>");
                exit();
            } else {
                // Incorrect password
                $error = "Invalid email or password.";
            }
        } else {
            // User not found
            $error = "Invalid email or password.";
        }

        // Close the prepared statement
        $stmt->close();
    }
}

// Close the database connection
$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8" />
    <title>Sign In | Lahomes - Real Estate Management Admin Template</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="A fully responsive premium admin dashboard template, Real Estate Management Admin Template" />
    <meta name="author" content="Techzaa" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <link rel="shortcut icon" href="assets/images/favicon.ico">
    <link href="assets/css/vendor.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <script src="assets/js/config.min.js"></script>
</head>
<body class="authentication-bg">
    <div class="account-pages pt-2 pt-sm-5 pb-4 pb-sm-5">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-5">
                    <div class="card auth-card">
                        <div class="card-body px-3 py-5">
                            <div class="mx-auto mb-4 text-center auth-logo">
                                <a href="index.html" class="logo-dark">
                                    <img src="assets/images/logo-dark.png" height="32" alt="logo dark">
                                </a>
                                <a href="index.html" class="logo-light">
                                    <img src="assets/images/logo-light.png" height="28" alt="logo light">
                                </a>
                            </div>

                            <h2 class="fw-bold text-uppercase text-center fs-18">Sign In</h2>
                            <p class="text-muted text-center mt-1 mb-4">Enter your email address and password to access account.</p>

                            <div class="px-4">
                                <form action="#" method="POST" class="authentication-form">
                                    <?php if (isset($error)) { ?>
                                        <div class="alert alert-danger"><?php echo $error; ?></div>
                                    <?php } ?>
                                    <div class="mb-3">
                                        <label class="form-label" for="example-email">Email</label>
                                        <input type="email" id="example-email" name="example-email" class="form-control bg-light bg-opacity-50 border-light py-2" placeholder="Enter your email">
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label" for="example-password">Password</label>
                                        <input type="password" id="example-password" name="example-password" class="form-control bg-light bg-opacity-50 border-light py-2" placeholder="Enter your password">
                                    </div>
                                    <div class="mb-3">
                                        <div class="form-check">
                                            <input type="checkbox" class="form-check-input" id="checkbox-signin">
                                            <label class="form-check-label" for="checkbox-signin">Remember me</label>
                                        </div>
                                    </div>
                                    <div class="mb-1 text-center d-grid">
                                        <button class="btn btn-danger py-2 fw-medium" type="submit">Sign In</button>
                                    </div>
                                </form>
                                <p class="mt-3 fw-semibold no-span">OR sign with</p>
                                <div class="text-center">
                                    <a href="javascript:void(0);" class="btn btn-outline-light shadow-none"><i class='bx bxl-google fs-20'></i></a>
                                    <a href="javascript:void(0);" class="btn btn-outline-light shadow-none"><i class='ri-facebook-fill fs-20'></i></a>
                                    <a href="javascript:void(0);" class="btn btn-outline-light shadow-none"><i class='bx bxl-github fs-20'></i></a>
                                </div>
                            </div> <!-- end col -->
                        </div> <!-- end card-body -->
                    </div> <!-- end card -->
                </div> <!-- end col -->
            </div> <!-- end row -->
        </div>
    </div>

    <!-- Vendor Javascript (Require in all Page) -->
    <script src="assets/js/vendor.js"></script>

    <!-- App Javascript (Require in all Page) -->
    <script src="assets/js/app.js"></script>
</body>
</html>