<?php
include('dbconnect.php');

if(isset($_GET['user_id'])) {
    $user_id = $_GET['user_id'];
    
    // Get user's projects
    $query = "SELECT tbl_lead_user_access_projects_project_id as project_id 
              FROM tbl_lead_user_access_projects 
              WHERE tbl_lead_user_access_projects_user_id = ?";
              
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    $projects = [];
    while($row = $result->fetch_assoc()) {
        $projects[] = $row['project_id'];
    }
    
    header('Content-Type: application/json');
    echo json_encode($projects);
} else {
    header('HTTP/1.1 400 Bad Request');
    echo json_encode(['error' => 'User ID is required']);
}
?>
