<?php
include('dbconnect.php');
include('function.php'); // Include your DB connection
date_default_timezone_set('Asia/Kolkata'); // Set to your timezone

// Get SMS messages that are due and not yet sent
//$sql = "SELECT * FROM scheduled_sms WHERE is_sent = 0 AND scheduled_datetime <= NOW()";
$sql = "SELECT * FROM scheduled_sms WHERE is_sent = 0 AND scheduled_datetime BETWEEN NOW() + INTERVAL 10 MINUTE AND NOW() + INTERVAL 11 MINUTE";

$result = mysqli_query($conn, $sql);

while ($row = mysqli_fetch_assoc($result)) {
    $mobile_number = $row['mobile_number'];
    $message = $row['message'];
    $id = $row['id'];
    $followup_type = $row['followup_type'];
    
    switch ($followup_type) {
        case 'In Progress':
            if(send_sms_inp($mobile_number, $message))
            {
                mysqli_query($conn, "UPDATE scheduled_sms SET is_sent = 1 WHERE id = $id");
            };
            break;
    
        case 'Not Connected':
            if(send_sms_site_followup($mobile_number, $message))
            {
                mysqli_query($conn, "UPDATE scheduled_sms SET is_sent = 1 WHERE id = $id");
            };
            break;
    
        case 'SV Scheduled':
            if(send_sms_site_scheduled($mobile_number, $message))
            {
                mysqli_query($conn, "UPDATE scheduled_sms SET is_sent = 1 WHERE id = $id");
            };
            break;
            
        case 'SV Completed':
            if(send_sms_site_visit_completed($mobile_number, $message))
            {
                mysqli_query($conn, "UPDATE scheduled_sms SET is_sent = 1 WHERE id = $id");
            };
            break;
            
        case 'EOI Completed':
            if(send_sms_eoi($mobile_number, $message))
            {
                mysqli_query($conn, "UPDATE scheduled_sms SET is_sent = 1 WHERE id = $id");
            };
            break;
    
        default:
            $message = "You have a followup update scheduled at $scheduled_datetime.";
            break;
    }
    
}
//file_put_contents(__DIR__ . '/cron_log.txt', date('Y-m-d H:i:s') . " Cron ran\n", FILE_APPEND);

?>
