<?php
include('dbconnect.php');
include('function.php');

// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Get the action from POST request
$action = $_POST['action'] ?? '';

switch($action) {
    case 'apply':
        // Get selected projects from POST
        $selectedAssignedUser = $_POST['assigneduser'] ?? [];
        
        // Store in session
        $_SESSION['selected_assignedUser'] = $selectedAssignedUser;
        
        // Return success response
        echo json_encode(['status' => 'success', 'message' => 'Assigned User filter applied']);
        break;
        
    case 'clear':
        // Clear the session variable
        unset($_SESSION['selected_assignedUser']);
        
        // Return success response
        echo json_encode(['status' => 'success', 'message' => 'Assigned user filter cleared']);
        break;
        
    default:
        // Return error for invalid action
        echo json_encode(['status' => 'error', 'message' => 'Invalid action']);
        break;
}
?> 